<?php

$chunked_products = array_chunk($high_rated_array, 2); // Split into chunks of 2 products per row

?>

<!-- suggested for you section -->
<section id="recommended" class="bg-white w-full shadow overflow-hidden">
    <!-- header -->
    <div class="flex px-6 py-4 justify-between items-center">
        <div class="title flex flex-col gap-0.5">
            <h1 class="text-xl font-medium">Suggested for You</h1>
            <p class="text-sm text-gray-400">Based on Your Interest</p>
        </div>
        <a href="#" class="bg-primary-blue text-xs font-medium text-white px-5 py-2.5 rounded-sm shadow-lg">VIEW ALL</a>
    </div>
    <hr>
    <!-- header -->

    <!-- products container -->
    <div class="p-4 relative">
        <?php foreach ($chunked_products as $row) { ?>
            <div class="flex justify-between gap-4 mb-6">
                <?php foreach ($row as $item) { ?>
                    <!-- one product -->
                    <div class="w-1/2 flex flex-col items-center gap-2 px-2 py-6 relative border rounded-lg shadow-sm">
                        <!-- image & product title -->
                        <a href="<?php printf('%s?product_id=%s', 'product.php', $item['product_id']); ?>" class="flex flex-col items-center text-center group">
                            <div class="w-36 h-36">
                                <img draggable="false" loading="lazy" class="w-full h-full object-contain" src="assets/images/products/<?php echo $item['product_img']; ?>.png" alt="<?php echo $item['product_img_alt']; ?>">
                            </div>
                            <h2 class="text-sm mt-4 group-hover:text-primary-blue">
                                <?php echo (strlen($item['product_title']) > 50) ? substr($item['product_title'], 0, 50) . "..." : $item['product_title']; ?>
                            </h2>
                        </a>
                        <!-- image & product title -->

                        <!-- product description -->
                        <div class="flex flex-col gap-2 items-center">
                            <!-- rating badge -->
                            <span class="text-sm text-gray-500 font-medium flex gap-2 items-center">
                                <span class="text-xs px-1.5 py-0.5 bg-primary-green rounded-sm text-white flex items-center gap-0.5">
                                    <?php echo $item['product_rating_star']; ?> <i class="material-icons md-12">star</i>
                                </span>
                                <span>(<?php echo number_format($item['product_rating_count']); ?>)</span>
                            </span>
                            <!-- rating badge -->

                            <!-- price container -->
                            <div class="flex items-center gap-1.5 text-md font-medium">
                                <span>₹<?php echo number_format($item['product_price']); ?></span>
                                <span class="text-gray-500 line-through text-xs">₹<?php echo number_format($item['product_cutted_price']); ?></span>
                                <span class="text-xs text-primary-green"><?php echo calcDiscount($item['product_price'], $item['product_cutted_price']); ?>%&nbsp;off</span>
                            </div>

                            <div class="flex items-center gap-1.5 text-md font-medium">
                                <span>Free Delivery</span>
                            
                                <span><img src="<?php echo $URL; ?>/assets/images/brands/brand_assured2.png" width="80"></span>
                            </div>
                            <!-- price container -->
                        </div>
                        <!-- product description -->
                    </div>
                    <!-- one product -->
                <?php } ?>
            </div>
        <?php } ?>
    </div>
    <!-- products container -->
</section>
<!-- suggested for you section -->
